/**
 * \file: util_arm_common.c
 * 
 * \version: $Revision: 1.12 $
 * 
 * \release: $Name: UTIL_r2_E05 $
 *
 * CPU dependent implementations.
 * 
 * \component: Utility
 * 
 * \author T. Polle / ADIT / SWG / tpolle(o)de.adit-jv.com
 * 
 * \copyright: (c) 2003 - 2008 ADIT Corporation 
 */

#include "util_lib_i.h"

/* PRQA: QAC Message 1006, 3006: Code cannot be generated with C. */
/* PRQA S 1006, 3006 L1 */

#ifdef BUILDENV_LINUX


 #ifdef __i386__
 /* For intel X86 compilation */

 S32 UTIL_swap(VP target, S32 new_value)
 {
     S32 old_val = 0;

     /* below code is not atomic
      * code is added only to make utility compilable on X86
      * FixMe: use xchg instruction of X86
      */

     old_val = *(S32*)target;
     *(S32*)target = new_value;

     return old_val;
 }

 S32 UTIL_test_swap32(VP target, S32 old_value, S32 new_value)
 {

     S32 result = 0;

     /* below code is not atomic
      * code is added only to make utility compilable on X86
      * FixMe: use xchg instruction of X86
      */

     if(old_value == *(S32*)target)
     {
         *(S32*)target = new_value;
         result = 1;
     }
     return result;
 }

/* for ARM Target */

  #elif defined __arm__

EXPORT S32 UTIL_swap(void* target, S32 new_value)
{
  S32 cur_value = 0;
  target = target; /*For removing Lint warning*/
  new_value = new_value;  /*For removing Lint warning*/

  /*PRQA: Lint Message : usage in line assembly is required here */
  /*lint -save -e123*/
  asm volatile
  (
    "SWP %0, %1, [%2]\n"
    :"=&r"(cur_value)
    :"r"(new_value), "r"(target)
  );
  /*lint -restore*/
  return cur_value;
 }


EXPORT S32 UTIL_test_swap32(VP target, S32 old_value, S32 new_value)
{
  S32 cur_value = 0;
  S32 rc        = 0;
  S32 success   = 1;
  target    = target;
  old_value = old_value;
  new_value = new_value;
  success   = success;
  rc        = rc;
  cur_value = cur_value;

  asm(
  "1:\n"
     "LDREX   %1,[%3]\n" /* cur_value, target */
     "CMP     %1,%4\n"   /* cur_value, old_value */
     "BNE     2f\n"
     "STREX   %0,%5,[%3]\n" /* success, new_value, target */
     "CMPEQ   %0,#0\n"      /* success */
     "BNE     1b\n"
  "2:\n"
     "STREXNE %2,%1,[%3]\n" /* rc, cur_value, target */
     :"=&r"(success), "=&r"(cur_value), "=&r"(rc)
     :"r"(target),"r"(old_value),"r"(new_value)
  );
  return (success == 0)? TRUE : FALSE;
}
 #endif


EXPORT U8 UTIL_get_cpu_core(void)
{
  /* It is costlier interms of performance to retrieve
   * core id from userspace. Hence fixed the core to core0
   * TTFis expects coreid = coreno + 1,for differentiating
   * single core traces
   */
  U32 core_id = 1;

 return (U8)core_id;
}
/* End of BUILDENV_LINUX*/

#elif BUILDENV_ESOL

EXPORT S32 UTIL_swap(VP target, S32 new_value)
{
  S32 cur_value = 0;
  target    = target;
  new_value = new_value;
  /*PRQA: Lint Message : usage in line assembly is required here */
  /* atomic operations implemented using assembler code */
  /*lint -save -e10 -e40*/
  __asm
  {
    SWP     cur_value, new_value,    [target]
  }
  /*lint -restore*/
  return cur_value;
}

EXPORT S32 UTIL_test_swap(VP target, S32 old_value, S32 new_value)
{
  S32 cur_value = 0;
  S32 success   = 0;
  target    = target;
  old_value = old_value;
  new_value = new_value;
  success   = success;
  /*PRQA: Lint Message : usage in line assembly is required here */
  /* atomic operations implemented using assembler code */
  /*lint -save -e10 -e40*/
  __asm
  {
  try:
    LDREX   cur_value, [target]
    CMP     cur_value, old_value
    STREXEQ success,   new_value,    [target]
    CMPEQ   success,   #0
    BNE     try
  }
  /*lint -restore*/
  return cur_value;
}


EXPORT __asm VP UTIL_get_threadid2(void)
{
  MRC     p15, 0, r0, c13, c0, 2
  BX      lr
}

EXPORT S32 UTIL_test_swap32(VP target, S32 old_value, S32 new_value)
  {
    S32 cur_value = 0;
    S32 rc        = 0;
    S32 success   = 1;
    target    = target;
    old_value = old_value;
    new_value = new_value;
    success   = success;
    cur_value = cur_value;
    rc        = rc;

    /*PRQA: Lint Message : usage in line assembly is required here */
    /* atomic operations implemented using assembler code */
    /*lint -save -e10 -e40*/
    __asm
    {
  try:
      LDREX   cur_value, [target]
      CMP     cur_value, old_value
      BNE     ext
      STREX   success,   new_value,    [target]
      CMPEQ   success,   #0
      BNE     try
  ext:
      STREXNE rc,   cur_value,    [target]
    }
    /*lint -restore*/

    return (success == 0)? TRUE : FALSE;
  }


EXPORT U8 UTIL_get_cpu_core(void)
  {
    U32 core_id = 0;
    /*PRQA: Lint Message : usage in line assembly is required here */
    /* atomic operations implemented using assembler code */
    /*lint -save -e10 -e40*/
    __asm {
      mrc     p15, 0, core_id, c0, c0, 5
    }
    /*lint -restore*/
    core_id++;
   return (U8)core_id;
  }


#endif /*End of BUILDENV_ESOL*/
/* PRQA L:L1 */
